
IF OBJECT_ID('UFD_EST_PED_CP_PARAM_PROD') IS NOT NULL
	BEGIN
		DROP FUNCTION UFD_EST_PED_CP_PARAM_PROD
	END

GO


CREATE FUNCTION UFD_EST_PED_CP_PARAM_PROD(@CD_EMP INT, @CD_PED_CP_PARAM INT, @CD_ARV_MERC_LINHA INT, @CD_FABRIC INT, @CD_PROD INT)														
RETURNS @RS_RETURN TABLE(
		CD_EMP					INT, 
		CD_PED_CP_PARAM			INT, 
		CD_PROD					INT)
AS
	BEGIN
		DECLARE @TST INT 
		
		--##############################################################################################
		--PRIORIDADE ANALISAR A ORDEM PARA O PRODUTO
		--##############################################################################################
		
		-------------------------------------------------------------------------------------------
		--VERIFICANO SE TEM ORDEM DE COMPRA ESPECIFICA PARA O PRODUTO
		-------------------------------------------------------------------------------------------
		INSERT INTO @RS_RETURN
			SELECT 
				@CD_EMP, 
				@CD_PED_CP_PARAM,
				@CD_PROD 
			FROM EST_PED_CP_PARAM_EST_PROD I
			WHERE I.ST_IGNORA			= 0
				AND I.CD_EMP			= @CD_EMP
				AND I.CD_PROD			= @CD_PROD
				AND I.CD_PED_CP_PARAM	= @CD_PED_CP_PARAM
		
		IF EXISTS (SELECT TOP 1 * FROM @RS_RETURN)
			BEGIN 
				RETURN
			END		
		
		-------------------------------------------------------------------------------------------
		--VERIFICANO SE TEM ORDEM DE IGNORACAO DE COMPRA ESPECIFICA PARA O PRODUTO
		-------------------------------------------------------------------------------------------
		IF EXISTS ( SELECT 
						I.CD_EMP
					FROM EST_PED_CP_PARAM_EST_PROD I
					WHERE I.ST_IGNORA			= 1
						AND I.CD_EMP			= @CD_EMP
						AND I.CD_PROD			= @CD_PROD
						AND I.CD_PED_CP_PARAM	= @CD_PED_CP_PARAM)
			BEGIN 
				RETURN
			END		
				
		
		
		--##############################################################################################
		--VERIFICANDO ORDEM DE IGNORACAO POR LINHA E FABRICANTE
		--##############################################################################################
		
		-------------------------------------------------------------------------------------------
		--VERIFICANO SE TEM ORDEM DE IGNORACAO DE COMPRA ESPECIFICA PARA A LINHA
		-------------------------------------------------------------------------------------------
		IF EXISTS ( SELECT 
						I.CD_EMP
					FROM EST_PED_CP_PARAM_EST_ARV_MERC_LINHA I
					WHERE I.ST_IGNORA			= 1
						AND I.CD_EMP			= @CD_EMP
						AND I.CD_ARV_MERC_LINHA	= @CD_ARV_MERC_LINHA
						AND I.CD_PED_CP_PARAM	= @CD_PED_CP_PARAM)
			BEGIN 
				RETURN
			END	
			

		-------------------------------------------------------------------------------------------
		--VERIFICANO SE TEM ORDEM DE IGNORACAO DE COMPRA ESPECIFICA PARA O FABRICANTE
		-------------------------------------------------------------------------------------------
		IF EXISTS ( SELECT 
						I.CD_EMP
					FROM EST_PED_CP_PARAM_EST_PROD_FABRIC I
					WHERE I.ST_IGNORA			= 1
						AND I.CD_EMP			= @CD_EMP
						AND I.CD_FABRIC			= @CD_FABRIC
						AND I.CD_PED_CP_PARAM	= @CD_PED_CP_PARAM)
			BEGIN 
				RETURN
			END			


		--##############################################################################################
		--SE CHEGOU ATE AQUI QUER DIZER QUE NAO TEM TRATAMENTO ESPECIFICO PARA O PRODUTO E IGNORACAO
		--##############################################################################################
		
		-------------------------------------------------------------------------------------------
		--VERIFICANO SE TEM ORDEM DE DE COMPRA PARA A LINHA E PARA O FABRICANTE
		-------------------------------------------------------------------------------------------		
		IF EXISTS ( SELECT I.CD_EMP 
					FROM EST_PED_CP_PARAM_EST_ARV_MERC_LINHA I
						INNER JOIN EST_PED_CP_PARAM_EST_PROD_FABRIC F ON 
							I.CD_EMP = F.CD_EMP 
							AND I.CD_PED_CP_PARAM = F.CD_PED_CP_PARAM 
					WHERE I.ST_IGNORA			= 0
						AND F.ST_IGNORA			= 0
						AND I.CD_EMP			= @CD_EMP			
						AND I.CD_PED_CP_PARAM	= @CD_PED_CP_PARAM)
			BEGIN										
				INSERT INTO @RS_RETURN
					SELECT 
						@CD_EMP, 
						@CD_PED_CP_PARAM,
						@CD_PROD 
					FROM EST_PED_CP_PARAM_EST_ARV_MERC_LINHA I
					WHERE I.ST_IGNORA			= 0
						AND I.CD_EMP			= @CD_EMP
						AND I.CD_ARV_MERC_LINHA	= @CD_ARV_MERC_LINHA
						AND I.CD_PED_CP_PARAM	= @CD_PED_CP_PARAM	
					INTERSECT 
					SELECT 
						@CD_EMP, 
						@CD_PED_CP_PARAM,
						@CD_PROD 
					FROM EST_PED_CP_PARAM_EST_PROD_FABRIC I
					WHERE I.ST_IGNORA			= 0
						AND I.CD_EMP			= @CD_EMP
						AND I.CD_FABRIC 		= @CD_FABRIC 
						AND I.CD_PED_CP_PARAM	= @CD_PED_CP_PARAM	
			END
		
		ELSE
			BEGIN		
				-----------------------------------------------------------------------------------
				--Testando produtos para comprar
				-----------------------------------------------------------------------------------
				SET @TST = 0
				
				WHILE NOT EXISTS (SELECT TOP 1 * FROM @RS_RETURN) AND @TST < 2
					BEGIN 
						IF @TST = 0
							BEGIN
								INSERT INTO @RS_RETURN
									SELECT 
										@CD_EMP, 
										@CD_PED_CP_PARAM,
										@CD_PROD 
									FROM EST_PED_CP_PARAM_EST_ARV_MERC_LINHA I
									WHERE I.ST_IGNORA			= 0
										AND I.CD_EMP			= @CD_EMP
										AND I.CD_ARV_MERC_LINHA	= @CD_ARV_MERC_LINHA
										AND I.CD_PED_CP_PARAM	= @CD_PED_CP_PARAM		
																										
							END				
						
						IF @TST = 1
							BEGIN
								INSERT INTO @RS_RETURN
									SELECT 
										@CD_EMP, 
										@CD_PED_CP_PARAM,
										@CD_PROD 
									FROM EST_PED_CP_PARAM_EST_PROD_FABRIC I
									WHERE I.ST_IGNORA			= 0
										AND I.CD_EMP			= @CD_EMP
										AND I.CD_FABRIC			= @CD_FABRIC
										AND I.CD_PED_CP_PARAM	= @CD_PED_CP_PARAM	
							END		
								
							
						SET @TST = @TST + 1	 					
										
					END				
			END
			
		RETURN	
	END		